
/**
 ******************************************************************************
 *
 * @file        MG32_Microphone_API.c
 * @brief       Sample Microphone by ADC. 
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2021/05/31
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_Microphone_API.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define MicPhoneFlashAddr   0x30000000;
#define MaxMicPhoneCNT      937

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint16_t ADCConvState=0xFFFF;
uint16_t MicPhoneCNT;
uint16_t MicPhoneIDX;               // MicPhone : the index of MicroBuf0 data.
uint8_t MicroBuf0[512];
uint8_t MicroBuf1[512];

/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/




/**
 *******************************************************************************
 * @brief       Initial LM35DZ 
 * @param[in]   None
 * @return		None
 *******************************************************************************
 */
void API_Microphone_Init(void)
{    
    
    // ADC initial parameters in API_ScanKey_Init function
        
}

/**
 *******************************************************************************
 * @brief       Get Audio data data from ADC 
 * @param[in]   None
 * @return		return LM35DZ data
 *******************************************************************************
 */
void API_Start_GerMicroPhone(void)
{
    MicPhoneCNT = 0;
    MicPhoneIDX = 0;
    ADCConvState = 0;
}

/**
 *******************************************************************************
 * @brief       Save Microphone data to flash
 * @param[in]   None
 * @return		return LM35DZ data
 *******************************************************************************
 */
void API_Microphone_Save(void)
{
    uint32_t Addr32;

    // calculate address mapping in QPI flash chip
    Addr32 = MicPhoneFlashAddr;
    Addr32 += (MicPhoneCNT << 9);          // 512 byte
    //

    if((MicPhoneCNT & 0x0001) == 0)
    {
//        API_QPI_Flash_Write(Addr32, MicroBuf0, 512);
    }
    else
    {
//        API_QPI_Flash_Write(Addr32, MicroBuf1, 512);
    }

    MicPhoneCNT ++;
    // stop record
    if(MicPhoneCNT > MaxMicPhoneCNT)
        ADCConvState = 0xFFFF;
}

